const express = require("express");
const {
  addProject,
  getAllProjects,
  getProjectById,
  updateProject,
  deleteProject,
  changeProjectStatus,
  checkProjectSlugExist,
} = require("../controllers/projectController");

const router = express.Router();

// Create a new project
router.post("/", addProject);

// Get all projects with pagination
router.get("/get-projects", getAllProjects);

// Get a project by ID
router.get("/:id", getProjectById);

// Update a project by ID
router.put("/:id", updateProject);

// Delete a project by ID
router.delete("/:id", deleteProject);

router.put("/change-project-status/:projectId", changeProjectStatus);

// Check slug exist
router.get("/check-slug-exist/:slug", checkProjectSlugExist);

module.exports = router;
