const express = require("express");
const {
  addMedia,
  getAllMedia,
  updateMedia,
  deleteMedia,
} = require("../controllers/mediaController");
const upload = require("../middleware/upload");
const router = express.Router();

// Assuming you're using Express.js
router.post("/add-media", upload.single("file"), addMedia);
router.get("/get-media", getAllMedia);
// router.put("/:id", updateMedia);
// Update media (with optional file upload)
router.put("/:id", upload.single("file"), updateMedia);
router.delete("/:id", deleteMedia); // New route to delete media

module.exports = router;
