const db = require("../config/db");
const path = require("path");

// const addMedia = async (req, res) => {
//   try {
//     let { media_name, media_url, media_type, thumbnail_url } = req.body;

//     // Trim inputs
//     media_name = media_name?.trim();
//     media_url = media_url?.trim();
//     media_type = media_type?.trim();
//     thumbnail_url = thumbnail_url?.trim();

//     // Basic validation
//     if (!media_name || !media_url || !media_type) {
//       return res
//         .status(400)
//         .json({ success: false, message: "All fields are required" });
//     }

//     const query =
//       "INSERT INTO media (media_name, media_url, media_type,thumbnail_url) VALUES (?, ?, ?,?)";
//     await db.query(query, [media_name, media_url, media_type, thumbnail_url]);

//     return res
//       .status(201)
//       .json({ success: true, message: "Media added successfully" });
//   } catch (error) {
//     console.error("Error adding media:", error.message);
//     return res.status(500).json({
//       success: false,
//       message: "Server error. Please try again later.",
//     });
//   }
// };

// const addMedia = async (req, res) => {
//   try {
//     let { media_name, media_url, media_type, thumbnail_url } =
//       req.body;

//     media_name = media_name?.trim();
//     media_url = media_url?.trim();
//     media_type = media_type?.trim();
//     thumbnail_url = thumbnail_url?.trim();

//     if (!media_name || !media_url || !media_type) {
//       return res
//         .status(400)
//         .json({ success: false, message: "All fields are required" });
//     }

//     // If file uploaded, get its relative path
//     let filePath = null;
//     if (req.file) {
//       // Example: /uploads/2025/10/images/file-123456789.jpg
//       filePath = path
//         .relative(path.join(__dirname, ".."), req.file.path)
//         .replace(/\\/g, "/");
//     }

//     const query =
//       "INSERT INTO media (media_name, media_url, media_type, thumbnail_url, file_path) VALUES (?, ?, ?, ?, ?)";

//     await db.query(query, [
//       media_name,
//       media_url,
//       media_type,
//       thumbnail_url,
//       filePath,
//     ]);

//     return res
//       .status(201)
//       .json({ success: true, message: "Media added successfully", filePath });
//   } catch (error) {
//     console.error("Error adding media:", error.message);
//     return res.status(500).json({
//       success: false,
//       message: "Server error. Please try again later.",
//     });
//   }
// };

// const addMedia = async (req, res) => {
//   try {
//     let { media_name, media_url, media_type, thumbnail_url } = req.body;

//     media_name = media_name?.trim();
//     media_url = media_url?.trim();
//     media_type = media_type?.trim();
//     thumbnail_url = thumbnail_url?.trim();

//     // if (!media_name || !media_url || !media_type) {
//     //   return res.status(400).json({
//     //     success: false,
//     //     message: "All fields are required",
//     //   });
//     // }

//     if (!media_name) {
//       return res.status(400).json({
//         success: false,
//         message: "Media name is required",
//       });
//     }

//     // Upload via link
//     if (!req.file && !media_url) {
//       return res.status(400).json({
//         success: false,
//         message: "Media URL is required when uploading via link",
//       });
//     }

//     // Upload locally
//     if (req.file && !media_type) {
//       return res.status(400).json({
//         success: false,
//         message: "Media type is required when uploading locally",
//       });
//     }

//     //  Handle file upload and format filePath
//     let filePath = null;
//     if (req.file) {
//       filePath = path
//         .relative(path.join(__dirname, ".."), req.file.path)
//         .replace(/\\/g, "/");

//       //  Ensure filePath starts with "/"
//       if (!filePath.startsWith("/")) {
//         filePath = "/" + filePath;
//       }
//     }

//     const query =
//       "INSERT INTO media (media_name, media_url, media_type, thumbnail_url, file_path) VALUES (?, ?, ?, ?, ?)";

//     await db.query(query, [
//       media_name,
//       media_url,
//       media_type,
//       thumbnail_url,
//       filePath,
//     ]);

//     return res.status(201).json({
//       success: true,
//       message: "Media added successfully",
//       filePath,
//     });
//   } catch (error) {
//     console.error("Error adding media:", error.message);
//     return res.status(500).json({
//       success: false,
//       message: "Server error. Please try again later.",
//     });
//   }
// };

const addMedia = async (req, res) => {
  try {
    let { media_name, media_url, media_type, thumbnail_url } = req.body;

    media_name = media_name?.trim() || null;
    media_url = media_url?.trim() || null;
    media_type = media_type?.trim();
    thumbnail_url = thumbnail_url?.trim() || null;

    // console.log("");

    // media_type is ALWAYS required (DB ENUM, NOT NULL)
    if (!media_type) {
      return res.status(400).json({
        success: false,
        message: "Media type is required",
      });
    }

    // Upload via link
    if (!req.file && !media_url) {
      return res.status(400).json({
        success: false,
        message: "Media URL is required when uploading via link",
      });
    }

    // Upload locally
    if (req.file && !media_type) {
      return res.status(400).json({
        success: false,
        message: "Media type is required when uploading locally",
      });
    }

    // Handle file upload
    let filePath = null;
    if (req.file) {
      filePath = path
        .relative(path.join(__dirname, ".."), req.file.path)
        .replace(/\\/g, "/");

      if (!filePath.startsWith("/")) {
        filePath = "/" + filePath;
      }
    }

    const nowUtc = new Date().toISOString().slice(0, 19).replace("T", " ");

    const query = `
      INSERT INTO media
      (media_name, media_url, media_type, thumbnail_url, file_path,created_at_utc)
      VALUES (?, ?, ?, ?, ?,?)
    `;

    await db.query(query, [
      media_name, // nullable
      media_url, // nullable
      media_type, // NOT NULL
      thumbnail_url, // nullable
      filePath, // nullable
      nowUtc,
    ]);

    return res.status(201).json({
      success: true,
      message: "Media added successfully",
      filePath,
    });
  } catch (error) {
    console.error("Error adding media:", error.message);
    return res.status(500).json({
      success: false,
      message: "Server error. Please try again later.",
    });
  }
};

const getAllMedia = async (req, res) => {
  try {
    const page = parseInt(req.query.page) || 1;
    const limit = parseInt(req.query.limit) || 20;
    const offset = (page - 1) * limit;

    const query = "SELECT * FROM media ORDER BY id DESC LIMIT ? OFFSET ?";
    const [media] = await db.query(query, [limit, offset]);

    // Count total records
    const [countResult] = await db.query("SELECT COUNT(*) AS total FROM media");
    const total = countResult[0].total;

    return res.status(200).json({
      success: true,
      currentPage: page,
      totalPages: Math.ceil(total / limit),
      totalRecords: total,
      data: media,
    });
  } catch (error) {
    console.error("Error fetching media:", error.message);
    return res.status(500).json({
      success: false,
      message: "Server error. Please try again later.",
    });
  }
};

// const updateMedia = async (req, res) => {
//   try {
//     const { id } = req.params;
//     let { media_name, media_url, media_type, thumbnail_url } = req.body;

//     // Trim inputs
//     media_name = media_name?.trim();
//     media_url = media_url?.trim();
//     media_type = media_type?.trim();
//     thumbnail_url = thumbnail_url?.trim();

//     if (!id || !media_name || !media_url || !media_type) {
//       return res
//         .status(400)
//         .json({ success: false, message: "All fields are required" });
//     }

//     const query = `
//       UPDATE media
//       SET media_name = ?, media_url = ?, media_type = ?,thumbnail_url =?
//       WHERE id = ?
//     `;
//     const [result] = await db.query(query, [
//       media_name,
//       media_url,
//       media_type,
//       thumbnail_url,
//       id,
//     ]);

//     if (result.affectedRows === 0) {
//       return res
//         .status(404)
//         .json({ success: false, message: "Media not found" });
//     }

//     return res
//       .status(200)
//       .json({ success: true, message: "Media updated successfully" });
//   } catch (error) {
//     console.error("Error updating media:", error.message);
//     return res.status(500).json({
//       success: false,
//       message: "Server error. Please try again later.",
//     });
//   }
// };

const updateMedia = async (req, res) => {
  try {
    const { id } = req.params;
    let { media_name, media_url, media_type, thumbnail_url } = req.body;

    // Trim inputs
    media_name = media_name?.trim() || null;
    media_url = media_url?.trim() || null;
    media_type = media_type?.trim();
    thumbnail_url = thumbnail_url?.trim() || null;

    if (!id) {
      return res.status(400).json({
        success: false,
        message: "Media ID is required",
      });
    }

    // media_type is ALWAYS required (DB ENUM)
    if (!media_type) {
      return res.status(400).json({
        success: false,
        message: "Media type is required",
      });
    }

    // Upload via link validation
    if (!req.file && !media_url) {
      return res.status(400).json({
        success: false,
        message: "Media URL is required when uploading via link",
      });
    }

    // Handle file upload
    let filePath = null;
    if (req.file) {
      filePath = path
        .relative(path.join(__dirname, ".."), req.file.path)
        .replace(/\\/g, "/");

      if (!filePath.startsWith("/")) {
        filePath = "/" + filePath;
      }
    }

    const query = `
      UPDATE media
      SET media_name = ?, media_url = ?, media_type = ?, thumbnail_url = ?, file_path = ?
      WHERE id = ?
    `;

    const [result] = await db.query(query, [
      media_name,
      media_url,
      media_type,
      thumbnail_url,
      filePath,
      id,
    ]);

    if (result.affectedRows === 0) {
      return res
        .status(404)
        .json({ success: false, message: "Media not found" });
    }

    return res.status(200).json({
      success: true,
      message: "Media updated successfully",
      filePath,
    });
  } catch (error) {
    console.error("Error updating media:", error.message);
    return res.status(500).json({
      success: false,
      message: "Server error. Please try again later.",
    });
  }
};

const deleteMedia = async (req, res) => {
  try {
    const { id } = req.params;

    if (!id) {
      return res
        .status(400)
        .json({ success: false, message: "Media ID is required" });
    }

    const query = "DELETE FROM media WHERE id = ?";
    const [result] = await db.query(query, [id]);

    if (result.affectedRows === 0) {
      return res.status(404).json({
        success: false,
        message: "Media not found or already deleted",
      });
    }

    return res
      .status(200)
      .json({ success: true, message: "Media deleted successfully" });
  } catch (error) {
    console.error("Error deleting media:", error.message);
    return res.status(500).json({
      success: false,
      message: "Server error. Please try again later.",
    });
  }
};

module.exports = { addMedia, getAllMedia, updateMedia, deleteMedia };
