const express = require("express");
require("dotenv").config();
const path = require("path");
const app = express();
const cors = require("cors");

//routes
const authRoutes = require("./routes/authRoutes");
const blogRoutes = require("./routes/blogRoutes");
const mediaRoutes = require("./routes/mediaRoutes");
const projectsRoutes = require("./routes/projectRoutes");
const categoriesRoutes = require("./routes/categoriesRoutes");
const categoryTypeRoutes = require("./routes/categoryTypeRoutes");

// Middleware
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use("/uploads", express.static(path.join(__dirname, "uploads")));
app.use(
  cors({
    origin: ["http://localhost:3000", "https://dashboard.mayankrajjain.in/"], // Adjust as needed
    methods: ["GET", "POST", "PUT", "DELETE"],
    credentials: true,
  }),
);

// Example route
app.get("/", (req, res) => {
  res.send("Welcome to Mayank Jain Dashboard Backend!");
});

// Start server
const PORT = process.env.PORT || 3000;

app.use("/api/blogs", blogRoutes);
app.use("/api/auth", authRoutes);
app.use("/api/media", mediaRoutes);
app.use("/api/projects", projectsRoutes);
app.use("/api/categories", categoriesRoutes);
app.use("/api/category-types", categoryTypeRoutes);

app.listen(PORT, () => {
  console.log(`Server running on port ${PORT}`);
});
